import numpy as np

A0 = np.array(
    [
     [ 0,1,0,1,1,0,0 ],
     [ 1,0,0,0,0,0,0 ],
     [ 0,1,0,1,0,0,0 ],
     [ 0,1,0,0,0,0,0 ],
     [ 0,0,0,1,0,0,0 ],
     [ 1,0,0,0,0,0,0 ],
     [ 0,1,1,0,0,0,0 ],
     ]
    )

H = A0.transpose()
D = np.linalg.inv(np.diag( [ sum(A0[i]) for i in range(len(A0)) ] ))
T = 1/len(A0) * np.ones((len(A0), len(A0)))
alpha = 0.85

P = alpha * H @ D + (1 - alpha) * T

print('Principal eigenvector:', np.round(max(np.real(np.linalg.eigvals(P))),4))

print('Pagerank:', np.round(np.real(np.linalg.eig(P)[1][0]),3))



